#include <stdio.h>
#include <stdlib.h>

// ?????????? ???????? ?? X ? Y ?? ??? 3*10^9. X^2 ???? ???? ?? 9*10^18.
// long long ?? ????????? ?? ??? ?????????.

typedef struct {
    long long x, y;
    int index;
} PodesiviVektor;

int main() {
    int N;
    if (scanf("%d", &N) != 1) return 1;

    PodesiviVektor vektori[N];
    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) return 1;
        vektori[i].index = i + 1; // ??????? ?? 1-????????
    }

    // ?????: ?? ?? ?? ??????? ??????? (0: ??, 1: ??)
    int izabrano[N];
    for (int i = 0; i < N; i++) {
        izabrano[i] = 0;
    }

    long long Rx = 0;
    long long Ry = 0;

    // Greedy ????????? ? ???????
    int promena = 1;
    while (promena) {
        promena = 0;
        
        for (int i = 0; i < N; i++) {
            long long xi = vektori[i].x;
            long long yi = vektori[i].y;
            
            // ???????? ??????? ??????????
            long long trenutni_kvad = Rx * Rx + Ry * Ry;
            
            long long novi_kvad;
            
            if (izabrano[i] == 0) {
                // ?????? 1: ????????? ???????
                novi_kvad = (Rx + xi) * (Rx + xi) + (Ry + yi) * (Ry + yi);
                
                if (novi_kvad > trenutni_kvad) {
                    Rx += xi;
                    Ry += yi;
                    izabrano[i] = 1;
                    promena = 1;
                }
            } else {
                // ?????? 2: ?????????? ???????
                novi_kvad = (Rx - xi) * (Rx - xi) + (Ry - yi) * (Ry - yi);
                
                if (novi_kvad > trenutni_kvad) {
                    Rx -= xi;
                    Ry -= yi;
                    izabrano[i] = 0;
                    promena = 1;
                }
            }
        }
    }

    // ?????? ????????
    int k = 0;
    for (int i = 0; i < N; i++) {
        if (izabrano[i]) {
            k++;
        }
    }

    printf("%d\n", k);
    
    int prvi = 1;
    for (int i = 0; i < N; i++) {
        if (izabrano[i]) {
            if (!prvi) {
                printf(" ");
            }
            printf("%d", vektori[i].index);
            prvi = 0;
        }
    }
    printf("\n");

    return 0;
}